/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	UncondemnAll.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"

//	uncondemn all the operations

HRESULT UncondemnAll()
{

	START_METHOD("UncondemnAll")

	HRESULT status = CONV_SUCCESS;
	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *design = NULL;
	status = activePart->GetDesign(&design);
	CHECK_RETURN_STATUS(status)

	// Get the number of operations in a design
	int n;
	status = design->GetOperationCount(&n);
	CHECK_RETURN_STATUS(status)

	IOperation *pOperation = NULL;
	// uncondemn all the operations
	for(long i=0; i <= n-1; i++)
	{
		status = design->GetOperation(i, &pOperation);
		CHECK_RETURN_STATUS(status)

		IOperation *operation = CAST(IOperation, pOperation);
		status = operation->SetCondemned(FALSE);
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("UncondemnAll")
}
